/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.events;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArmorAttackContext;
import com.xiaoyue.tinkers_ingenuity.content.library.events.AttackSpeedModifyEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.events.LivingCalculateAbsEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.events.TinkerToolCriticalEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.IngenuityHooks;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.ArmorCombatHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.AttackSpeedHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.KnockBackHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.ToolCombatHook;
import com.xiaoyue.tinkers_ingenuity.utils.ToolUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="tinkers_ingenuity", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CombatHandler {
    private static ArmorCombatHook armorCombat(ModifierEntry entry) {
        return (ArmorCombatHook)entry.getHook(IngenuityHooks.ARMOR_COMBAT_HOOK);
    }

    private static ToolCombatHook toolCombat(ModifierEntry entry) {
        return (ToolCombatHook)entry.getHook(IngenuityHooks.TOOL_COMBAT_HOOK);
    }

    private static KnockBackHook knockBack(ModifierEntry entry) {
        return (KnockBackHook)entry.getHook(IngenuityHooks.KNOCK_BACK_HOOK);
    }

    private static AttackSpeedHook attackSpeed(ModifierEntry entry) {
        return (AttackSpeedHook)entry.getHook(IngenuityHooks.ATTACK_SPEED_HOOK);
    }

    private static ArmorAttackContext context(DamageSource source, LivingEntity entity, EquipmentContext ctx, EquipmentSlot slot) {
        return new ArmorAttackContext(source, entity, ctx, slot);
    }

    public static void onHurtEntity(LivingHurtEvent event, LivingEntity entity) {
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            EquipmentContext context = new EquipmentContext(attacker);
            if (!context.hasModifiableArmor()) {
                return;
            }
            for (EquipmentSlot slot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                IToolStackView armor = context.getToolInSlot(slot);
                if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
                armor.getModifierList().forEach(e -> CombatHandler.armorCombat(e).onHurtTarget(armor, event, CombatHandler.context(event.getSource(), entity, context, slot), e.getLevel()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        CombatHandler.onHurtEntity(event, event.getEntity());
        EquipmentContext context = new EquipmentContext(event.getEntity());
        if (!context.hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slot : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slot);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            armor.getModifierList().forEach(e -> CombatHandler.armorCombat(e).onTakeHurt(armor, event, CombatHandler.context(event.getSource(), event.getEntity(), context, slot), e.getLevel()));
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        EquipmentContext context;
        LivingEntity entity = event.getEntity();
        ToolStack tool = ToolUtils.getToolInHand(entity);
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
            tool.getModifierList().forEach(e -> CombatHandler.toolCombat(e).onTakeDamage((IToolStackView)tool, event, event.getSource(), entity, e.getLevel()));
        }
        if (!(context = new EquipmentContext(entity)).hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slotType);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            armor.getModifierList().forEach(e -> CombatHandler.armorCombat(e).onTakeDamage(armor, event, CombatHandler.context(event.getSource(), entity, context, slotType), e.getLevel()));
        }
    }

    @SubscribeEvent
    public static void onLivingCalculate(LivingCalculateAbsEvent event) {
        LivingEntity attacker = event.getLivingAttacker();
        if (attacker == null) {
            return;
        }
        ToolStack tool = ToolUtils.getToolInHand(attacker);
        if (!ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
            return;
        }
        tool.getModifierList().forEach(e -> CombatHandler.toolCombat(e).onDamageAbs((IToolStackView)tool, event, attacker, event.getEntity(), e.getLevel()));
    }

    @SubscribeEvent
    public static void onLivingKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            ToolStack tool = ToolUtils.getToolInHand(attacker);
            if (!ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
                return;
            }
            tool.getModifierList().forEach(e -> CombatHandler.toolCombat(e).onKillTarget((IToolStackView)tool, event, attacker, event.getEntity(), e.getLevel()));
        }
    }

    @SubscribeEvent
    public static void onKnockBack(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        EquipmentContext context = new EquipmentContext(entity);
        if (!context.hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slotType);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            armor.getModifierList().forEach(e -> CombatHandler.knockBack(e).onKnockBack(armor, event, entity, e.getLevel()));
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        EquipmentContext context = new EquipmentContext(entity);
        if (!context.hasModifiableArmor()) {
            return;
        }
        for (EquipmentSlot slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
            IToolStackView armor = context.getToolInSlot(slotType);
            if (!ToolUtils.isNotBrokenOrNull(armor)) continue;
            armor.getModifierList().forEach(e -> CombatHandler.armorCombat(e).onTakeHeal(armor, event, entity, e.getLevel()));
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(TinkerToolCriticalEvent event) {
        LivingEntity attacker = event.getContext().getAttacker();
        if (event.getContext().getLivingTarget() == null) {
            return;
        }
        event.getTool().getModifierList().forEach(e -> CombatHandler.toolCombat(e).onCriticalHit(event.getTool(), event, attacker, event.getContext().getLivingTarget(), e.getLevel()));
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_21211_().m_41619_()) {
                return;
            }
            ToolStack tool = ToolStack.from((ItemStack)player.m_21211_());
            tool.getModifierList().forEach(e -> CombatHandler.toolCombat(e).onShieldBlocked((IToolStackView)tool, event, player, event.getDamageSource(), e.getLevel()));
        }
    }

    @SubscribeEvent
    public static void onModifyAttackCooldown(AttackSpeedModifyEvent event) {
        Player player = event.getPlayer();
        ToolStack tool = ToolUtils.getToolInHand((LivingEntity)player);
        if (ToolUtils.isNotBrokenOrNull((IToolStackView)tool)) {
            tool.getModifierList().forEach(e -> CombatHandler.attackSpeed(e).modifyAttackCooldown((IToolStackView)tool, player, event, e.getLevel()));
        }
    }
}

